package com.ejie.ab04b.dao.custom;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.TramiteAperturasDaoImpl;
import com.ejie.ab04b.dao.TramiteOS2DaoImpl;
import com.ejie.ab04b.model.OS2;
import com.ejie.ab04b.model.Tramite;
import com.ejie.ab04b.model.TramiteOS2;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;

/**
 * TramiteOS2DaoImpl generated by UDA, 02-Feb-2017 13:49:16.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class TramiteOS2CustomDaoImpl extends TramiteOS2DaoImpl implements
		TramiteOS2CustomDao {

	private static final String QUERY_SELECT = "SELECT t1.ID_TRAMITE_092 IDTRAMITE092, t1.TIPO_TRAMITE_092 TIPOTRAMITE092, t1.TERRIT_OS2_092 TERRITOS2092, t1.ANO_OS2_092 ANOOS2092, t1.NUM_OS2_092 NUMOS2092, t1.PROCEDURE_ID_089 PROCEDUREID089, t1.PROCEEDING_ID_089 PROCEEDINGID089, t1.DESCRIPCION_ES_089 DESCRIPCIONES089, t1.DESCRIPCION_EU_089 DESCRIPCIONEU089 FROM VTRAMITES_OS2 t1 ";

	private static final String QUERY_SELECT_2 = "SELECT t1.ID_TRAMITE_092 IDTRAMITE092, t1.TIPO_TRAMITE_092 TIPOTRAMITE092, t1.TERRIT_OS2_092 TERRITOS2092, t1.ANO_OS2_092 ANOOS2092, t1.NUM_OS2_092 NUMOS2092,t1.PROCEEDING_ID_089 PROCEEDINGID089,  J.FECPRE_056 FECHAPRESENTACION056 FROM VTRAMITES_OS2 t1 LEFT JOIN AB0456T00 J ON t1.TERRIT_OS2_092 = J.TERAPE_056 AND t1.ANO_OS2_092  = J.ANOAPE_056 AND t1.NUM_OS2_092   = J.NUMAPE_056  ";
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<TramiteOS2> rwMap = new RowMapper<TramiteOS2>() {
		public TramiteOS2 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			TramiteOS2 tram = new TramiteOS2(resultSet.getLong("IDTRAMITE092"),
					null, null);

			tram.setos2(new OS2(resultSet.getString("TERRITOS2092"), resultSet
					.getString("ANOOS2092"), resultSet.getInt("NUMOS2092")));

			tram.setTipoTramite(new Tramite(
					resultSet.getLong("TIPOTRAMITE092"), resultSet
							.getString("PROCEDUREID089"), resultSet
							.getString("PROCEEDINGID089"), resultSet
							.getString("DESCRIPCIONES089"), resultSet
							.getString("DESCRIPCIONEU089")));

			return tram;
		}
	};

	private RowMapper<TramiteOS2> rwMapDoc = new RowMapper<TramiteOS2>() {
		public TramiteOS2 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			TramiteOS2 tram = new TramiteOS2(resultSet.getLong("IDTRAMITE092"),
					null, null);

			OS2 os2 = new OS2();
			os2.setTeros2060(resultSet.getString("TERRITOS2092"));
			os2.setAnoos2060(resultSet.getString("ANOOS2092"));
			os2.setNumos2060(resultSet.getInt("NUMOS2092"));
			os2.setFecpre060(resultSet.getDate("FECHAPRESENTACION056"));
			tram.setos2(os2);

			Tramite tramite = new Tramite();
			tramite.setProceedingId089(resultSet.getString("PROCEEDINGID089"));
			tram.setTipoTramite(tramite);

			return tram;
		}
	};

	/**
	 * Finds a single row in the TramiteOS2 table.
	 * 
	 *  tramiteOS2
	 *            TramiteOS2
	 *  TramiteOS2
	 *
	 * @param tramiteOS2 the tramite OS 2
	 * @return the tramite OS 2
	 */
	@Transactional(readOnly = true)
	public TramiteOS2 vfind(TramiteOS2 tramiteOS2) {
		StringBuilder query = new StringBuilder(
				TramiteOS2CustomDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.ID_TRAMITE_092 = ? ");

		List<TramiteOS2> tramiteOS2List = this.getJdbcTemplate().query(
				query.toString(), this.rwMap, tramiteOS2.getIdTramite092());
		return (TramiteOS2) DataAccessUtils.uniqueResult(tramiteOS2List);
	}

	/**
	 * Finds a single row in the TramiteOS2 table.
	 * 
	 *  idTipoTramite
	 *            Long
	 *  os2
	 *            OS2
	 *  TramiteOS2
	 *
	 * @param idTipoTramite the id tipo tramite
	 * @param os2 the os 2
	 * @return the tramite OS 2
	 */
	@Transactional(readOnly = true)
	public TramiteOS2 findLastTramiteByTipo(Long idTipoTramite, OS2 os2) {
		StringBuilder query = new StringBuilder(
				TramiteOS2CustomDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.TIPO_TRAMITE_092 = ? AND t1.TERRIT_OS2_092 = ? AND ANO_OS2_092 = ? AND NUM_OS2_092 = ? ");
		query.append(" ORDER BY t1.ID_TRAMITE_092 DESC ");

		List<TramiteOS2> tramiteOS2List = this.getJdbcTemplate().query(
				query.toString(), this.rwMap, idTipoTramite,
				os2.getTeros2060(), os2.getAnoos2060(), os2.getNumos2060());

		if (tramiteOS2List == null || tramiteOS2List.isEmpty()) {
			return null;
		}
		return tramiteOS2List.get(0);
	}

	/**
	 * Finds a list of rows in the TramiteOS2 table.
	 * 
	 *  tramiteOS2
	 *            TramiteOS2
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<TramiteOS2>
	 *
	 * @param tramiteOS2 the tramite OS 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<TramiteOS2> vfindAll(TramiteOS2 tramiteOS2,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				TramiteOS2CustomDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tramiteOS2);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<TramiteOS2>) this.getJdbcTemplate().query(
				query.toString(), this.rwMap, params.toArray());
	}

	/* (non-Javadoc)
	 * @see com.ejie.ab04b.dao.custom.TramiteOS2CustomDao#findAllImprimirDocsOS2Like(com.ejie.ab04b.model.TramiteOS2, com.ejie.x38.dto.JQGridRequestDto, boolean)
	 */
	@Override
	public List<TramiteOS2> findAllImprimirDocsOS2Like(
			TramiteOS2 filterAb0492s00, JQGridRequestDto jqGridRequestDto,
			boolean b) {
		StringBuilder query = new StringBuilder(
				TramiteOS2CustomDaoImpl.QUERY_SELECT_2);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereDocumentoMap(filterAb0492s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<TramiteOS2>) this.getJdbcTemplate().query(
				query.toString(), this.rwMapDoc, params.toArray());
	}

	/* (non-Javadoc)
	 * @see com.ejie.ab04b.dao.custom.TramiteOS2CustomDao#findAllLikeImprimirDocsOS2Count(com.ejie.ab04b.model.TramiteOS2, boolean)
	 */
	@Override
	public Long findAllLikeImprimirDocsOS2Count(TramiteOS2 tramiteOS2, boolean b) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM VTRAMITES_OS2 t1 LEFT JOIN AB0456T00 J ON t1.TERRIT_OS2_092 = J.TERAPE_056 AND t1.ANO_OS2_092  = J.ANOAPE_056 AND t1.NUM_OS2_092   = J.NUMAPE_056  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereDocumentoMap(tramiteOS2);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.getJdbcTemplate().queryForLong(query.toString(),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TramiteOS2 entity
	 * 
	 *  tramiteOS2
	 *            TramiteOS2 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param tramiteOS2 the tramite OS 2
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(TramiteOS2 tramiteOS2) {

		StringBuilder where = new StringBuilder(
				TramiteOS2DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tramiteOS2 != null && tramiteOS2.getIdTramite092() != null) {
			where.append(" AND t1.ID_TRAMITE_092 = ?");
			params.add(tramiteOS2.getIdTramite092());
		}
		if (tramiteOS2 != null && tramiteOS2.getTipoTramite() != null
				&& tramiteOS2.getTipoTramite().getIdTramite089() != null) {
			where.append(" AND t1.TIPO_TRAMITE_092 = ?");
			params.add(tramiteOS2.getTipoTramite().getIdTramite089());
		}
		if (tramiteOS2 != null && tramiteOS2.getos2() != null
				&& tramiteOS2.getos2().getTeros2060() != null) {
			where.append(" AND t1.TERRIT_OS2_092 = ?");
			params.add(tramiteOS2.getos2().getTeros2060());
		}
		if (tramiteOS2 != null && tramiteOS2.getos2() != null
				&& tramiteOS2.getos2().getAnoos2060() != null) {
			where.append(" AND t1.ANO_OS2_092 = ?");
			params.add(tramiteOS2.getos2().getAnoos2060());
		}
		if (tramiteOS2 != null && tramiteOS2.getos2() != null
				&& tramiteOS2.getos2().getNumos2060() != null) {
			where.append(" AND t1.NUM_OS2_092 = ?");
			params.add(tramiteOS2.getos2().getNumos2060());
		}

		if (tramiteOS2 != null && tramiteOS2.getTipoTramite() != null
				&& tramiteOS2.getTipoTramite().getIdTramite089() != null) {
			where.append(" AND t1.TIPO_TRAMITE_092 = ?");
			params.add(tramiteOS2.getTipoTramite().getIdTramite089());
		}
		if (tramiteOS2 != null && tramiteOS2.getTipoTramite() != null
				&& tramiteOS2.getTipoTramite().getProcedureId089() != null) {
			where.append(" AND t1.PROCEDURE_ID_089 = ?");
			params.add(tramiteOS2.getTipoTramite().getProcedureId089());
		}
		if (tramiteOS2 != null && tramiteOS2.getTipoTramite() != null
				&& tramiteOS2.getTipoTramite().getProceedingId089() != null) {
			where.append(" AND t1.PROCEEDING_ID_089 = ?");
			params.add(tramiteOS2.getTipoTramite().getProceedingId089());
		}
		if (tramiteOS2 != null && tramiteOS2.getTipoTramite() != null
				&& tramiteOS2.getTipoTramite().getDescripcionEs089() != null) {
			where.append(" AND t1.DESCRIPCION_ES_089 = ?");
			params.add(tramiteOS2.getTipoTramite().getDescripcionEs089());
		}
		if (tramiteOS2 != null && tramiteOS2.getTipoTramite() != null
				&& tramiteOS2.getTipoTramite().getDescripcionEu089() != null) {
			where.append(" AND t1.DESCRIPCION_EU_089 = ?");
			params.add(tramiteOS2.getTipoTramite().getDescripcionEu089());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TramiteOS2 entity
	 * 
	 *  tramiteOS2
	 *            TramiteOS2 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param tramiteOs2 the tramite os 2
	 * @return the where documento map
	 */
	private Map<String, ?> getWhereDocumentoMap(TramiteOS2 tramiteOs2) {

		StringBuilder where = new StringBuilder(
				TramiteAperturasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tramiteOs2 != null && tramiteOs2.getos2() != null
				&& tramiteOs2.getos2().getTeros2060() != null) {
			where.append(" AND t1.TERRIT_OS2_092 = ?");
			params.add(tramiteOs2.getos2().getTeros2060());
		}
		if (tramiteOs2 != null && tramiteOs2.getos2() != null
				&& tramiteOs2.getos2().getAnoos2060() != null) {
			where.append(" AND t1.ANO_OS2_092 = ?");
			params.add(tramiteOs2.getos2().getAnoos2060());
		}
		if (tramiteOs2 != null && tramiteOs2.getos2() != null
				&& tramiteOs2.getos2().getNumExpDesde() != null) {
			where.append(" AND t1.NUM_OS2_092 >= ? ");
			params.add(tramiteOs2.getos2().getNumExpDesde());
		}

		if (tramiteOs2 != null && tramiteOs2.getos2() != null
				&& tramiteOs2.getos2().getNumExpHasta() != null) {
			where.append(" AND t1.NUM_OS2_092 <= ?");
			params.add(tramiteOs2.getos2().getNumExpHasta());
		}

		if (tramiteOs2 != null && tramiteOs2.getTipoTramite() != null
				&& tramiteOs2.getTipoTramite().getProceedingId089() != null) {
			where.append(" AND t1.PROCEEDING_ID_089 = ?");
			params.add(tramiteOs2.getTipoTramite().getProceedingId089());
		}

		if (tramiteOs2 != null && tramiteOs2.getos2() != null
				&& tramiteOs2.getos2().getFecpreDesde() != null) {
			where.append(" AND J.FECPRE_056 >= ? ");
			params.add(tramiteOs2.getos2().getFecpreDesde());
		}

		if (tramiteOs2 != null && tramiteOs2.getos2() != null
				&& tramiteOs2.getos2().getFecpreHasta() != null) {
			where.append(" AND J.FECPRE_056 <= ?");
			params.add(tramiteOs2.getos2().getFecpreHasta());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

}
